
package com.handheld.LF134KDemo;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import cn.pda.serialport.SerialPort;
import cn.pda.serialport.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class LF134KManager {
    private SerialPort mSerialport;
    private InputStream mIn;
    private OutputStream mOut;
    public static int Port = 13;
    public static int BaudRate = 9600;
    public static int Power = 3;
    public static final int MSG_RFID_134K = 1101;
    public static final String KEY_134K_ID = "134k_id";
    public static final String KEY_134K_COUNTRY = "134k_country";
    private Handler handler = null;
    private boolean running = true;
    private boolean startFlag = false;
    private String tag = "Rfid134k";
    ReadThread readThread;

    public LF134KManager() throws SecurityException, IOException {
        this.mSerialport = new SerialPort(Port, BaudRate, 0);
        Log.e("port", Port + ":" + BaudRate + ":" + Power);
        switch (Power) {
            case 0:
                this.mSerialport.power3v3on();
                break;
            case 1:
                this.mSerialport.power_5Von();
                break;
            case 2:
                this.mSerialport.scaner_poweron();
                break;
            case 3:
                this.mSerialport.psam_poweron();
                break;
            case 4:
                this.mSerialport.rfid_poweron();
        }

        this.mIn = this.mSerialport.getInputStream();
        this.mOut = this.mSerialport.getOutputStream();
        sleep(500);
        byte[] temp = new byte[16];
        this.mIn.read(temp);
        this.readThread = new ReadThread();
        this.readThread.start();
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    private byte[] getRecv() {
        byte[] buffer = new byte[512];
        byte[] recv = null;
        int size = 0;
        int available = 0;

        try {
            available = this.mIn.available();
            if (available > 0) {
                sleep(40);
                size = this.mIn.read(buffer);
                if (size > 0) {
                    recv = new byte[size];
                    System.arraycopy(buffer, 0, recv, 0, size);
                    if (recv != null) {
                        this.resolveData(recv);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return recv;
    }

    private Map<Integer, Integer> resolveData(byte[] recv) {
        Log.e("resolve", Tools.Bytes2HexString(recv, recv.length));
        Map<Integer, Integer> map = null;
        if (recv.length > 7) {
            map = new HashMap();
            int countryCode = (recv[0] & 255) + (recv[1] & 255) * 256;
            int id = (recv[2] & 255) + (recv[3] & 255) * 256 + (recv[4] & 255) * 256 * 256 + (recv[5] & 255) * 256 * 256 * 256 + (recv[6] & 255) * 256 * 256 * 256 * 256;
            String type = " ";
            if (recv.length > 20) {
                if (recv[29] == 0x03) {
                    type = "FDX-B";
                } else if (recv[29] == 0x07) {
                    type = "HDX";
                }
            } else {
                if (recv[19] == 0x03) {
                    type = "FDX-B";
                } else if (recv[19] == 0x07) {
                    type = "HDX";
                }
            }
            this.sendMsg(countryCode, id, type);
            map.put(id, countryCode);
        }

        return map;
    }

    private void sendMsg(int countryCode, int id, String type) {
        if (this.handler != null) {
            Message msg = new Message();
            Bundle bundle = new Bundle();
            msg.what = 1101;
            bundle.putInt("134k_id", id);
            bundle.putInt("134k_country", countryCode);
            bundle.putString("type", type);
            msg.setData(bundle);
            this.handler.sendMessage(msg);
        }

    }

    private void findCardCMD() {
        byte[] cmd = new byte[]{-86};

        try {
            this.mOut.write(cmd);
            this.mOut.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    public void startRead() {
        this.startFlag = true;
        this.mSerialport.rfidPoweron();
    }

    public void stopRead() {
        this.startFlag = false;
        this.mSerialport.rfidPoweroff();
    }

    public void close() {
        try {
            this.running = false;
            this.startFlag = false;
            this.readThread.interrupt();
            sleep(100);
            if (this.mOut != null) {
                this.mOut.close();
            }

            if (this.mIn != null) {
                this.mIn.close();
            }

            if (this.mSerialport != null) {
                switch (Power) {
                    case 0:
                        this.mSerialport.power3v3off();
                        break;
                    case 1:
                        this.mSerialport.power_5Voff();
                        break;
                    case 2:
                        this.mSerialport.scaner_poweroff();
                        break;
                    case 3:
                        this.mSerialport.psam_poweroff();
                        break;
                    case 4:
                        this.mSerialport.rfid_poweroff();
                }

                this.mSerialport.close(Port);
                Log.e("134k", "Close" + Port);
            }
        } catch (Exception var2) {
        }

    }

    private static void sleep(int time) {
        try {
            Thread.sleep((long)time);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

    private class ReadThread extends Thread {
        private ReadThread() {
        }

        public void run() {
            super.run();

            while(LF134KManager.this.running) {
                if (LF134KManager.this.startFlag) {
                    LF134KManager.sleep(10);
                    LF134KManager.this.findCardCMD();
                    LF134KManager.this.getRecv();
                }
            }

        }
    }
}
